﻿<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="System.Collections" %>
<%@ Import Namespace="System.Diagnostics" %>
<%@ Import Namespace="System.Text" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Dokumenty sprzedaży</title>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">

public class ParametryContext : ContextBase { 
	public ParametryContext(Context cx) : base(cx) {
	}
	
	bool duplikatyDokumentów = true;
	
	[Priority(1)]
	public bool DuplikatyDokumentów {
		get { return duplikatyDokumentów; }
		set { duplikatyDokumentów = value; }
	}
	
	bool duplikatyPozycji = true;
	
	[Priority(2)]
	public bool DuplikatyPozycji {
		get { return duplikatyPozycji; }
		set { duplikatyPozycji = value; }
	}
	
	bool poprawnośćPłatności = true;
	
	[Priority(3)]
	public bool PoprawnośćPłatności {
		get { return poprawnośćPłatności; }
		set { poprawnośćPłatności = value; }
	}
	
	bool relacjePodrzędne = true;
	
	[Priority(4)]
	public bool RelacjePodrzędne {
		get { return relacjePodrzędne; }
		set { relacjePodrzędne = value; }
	}
	
	bool dokumentyWBuforze = true;
	
	[Priority(5)]
	public bool DokumentyWBuforze {
		get { return dokumentyWBuforze; }
		set { dokumentyWBuforze = value; }
	}
	
	bool niezatwierdzoneKorekty = true;
	
	[Priority(6)]
	public bool NiezatwierdzoneKorekty {
		get { return niezatwierdzoneKorekty; }
		set { 
			niezatwierdzoneKorekty = value; 
			OnChanged(EventArgs.Empty);
		}
	}
	
	bool bezPozycji = true;
	
	[Priority(7)]
	public bool BezPozycji {
		get { return bezPozycji; }
		set { 
			bezPozycji = value; 
			OnChanged(EventArgs.Empty);
		}
	}
	
	bool podejrzaneCeny = true;
	
	[Priority(100)]
	public bool PodejrzaneCeny {
		get { return podejrzaneCeny; }
		set { 
			podejrzaneCeny = value; 
			OnChanged(EventArgs.Empty);
		}
	}
	
	double proporcjaCeny = 4;
	
	[Priority(101)]
	[DefaultWidth(8)]
	public double ProporcjaCeny {
		get { return proporcjaCeny; }
		set { proporcjaCeny = value; }
	}
	
	public bool IsReadOnlyProporcjaCeny() {
		return !PodejrzaneCeny;
	}
}

ParametryContext parametry;

[Context]
public ParametryContext Parametry {
	get { return parametry; }
	set { parametry = value; }
}

public class BłędnyDokument : IComparable {

	readonly ArrayList błędy = new ArrayList();

	public BłędnyDokument(DokumentHandlowy dokument) {
		this.dokument = dokument;
	}
	
	DokumentHandlowy dokument;
	
	public DokumentHandlowy Dokument {
		get { return dokument; }
	}
	
	public IList Błędy {
		get { return błędy; }
	}
	
	public void DodajBłąd(string info) {
		błędy.Add(info);
	}
	
	public int CompareTo(object v) {
		BłędnyDokument bd = (BłędnyDokument)v;
		return string.Compare(Dokument.Numer.Pelny, bd.Dokument.Numer.Pelny);
	}
	
}

Hashtable ht = new Hashtable();

BłędnyDokument Błąd(DokumentHandlowy dokument) {
	BłędnyDokument błąd = (BłędnyDokument)ht[dokument];
	if (błąd==null) {
		błąd = new BłędnyDokument(dokument);
		ht[dokument] = błąd;
	}
	return błąd;
}

string klucz(DokumentHandlowy dok) {
	StringBuilder s = new StringBuilder();
	
	s.Append(dok.Data);
	s.Append(';');
	s.Append(dok.Kontrahent.ID);
	s.Append(';');
	s.Append(dok.Definicja.ID);
	
	foreach (PozycjaDokHandlowego poz in dok.Pozycje) {
		s.Append(';');
		s.Append(poz.Towar.ID);
		s.Append(';');
		s.Append(poz.Ilosc.ToString());
		s.Append(';');
		s.Append(poz.WartoscCy.ToString());
	}
	
	return s.ToString();
}

void sprawdźRelacje(DokumentHandlowy dokument) {
	DefDokHandlowego def = dokument.Definicja;
	
	bool tylkoUsługi = true;
	foreach (PozycjaDokHandlowego poz in dokument.Pozycje) {
		if (poz.Towar.Typ!=TypTowaru.Usługa) {
			tylkoUsługi = false;
			break;
		}
	}

	if (dokument.Bufor && Parametry.NiezatwierdzoneKorekty) {
		foreach (RelacjaHandlowa rh in dokument.PodrzedneRelacje) {
			if (rh is RelacjaHandlowa.Korekta)
				Błąd(dokument).DodajBłąd("Dokument korygowany nie może znajdować się w buforze");
		}
	}
	
	foreach (DefRelacjiHandlowej defr in def.Podrzedne) {
        if( defr.ZNadrzednego.AutomatycznieNowy && !defr.DefinicjaPodrzednego.Blokada ) {
			if (dokument.Podrzędne[defr.Typ]==null && 
				(defr.Typ!=TypRelacjiHandlowej.HandlowoMagazynowa || !tylkoUsługi))
				Błąd(dokument).DodajBłąd("Nieznaleziony dokument podrzędny w relacji: "+defr);
		}
	}
}

void sprawdźCeny(DokumentHandlowy dokument) {
	foreach (PozycjaDokHandlowego poz in dokument.Pozycje) {
		if (poz.Cena.Value!=0) {
			foreach (Cena cena in poz.Towar.Ceny) {
				DoubleCy d;
				if (dokument.LiczonaOd==SposobLiczeniaVAT.OdNetto)
					d = cena.Netto;
				else
					d = cena.Brutto;
				if (d.Value!=0 && DoubleCy.EqualSymbols(d, poz.Cena) && poz.Ilosc.Symbol==cena.Jednostka.Kod) {
					if (d.Value*Parametry.ProporcjaCeny<poz.Cena.Value) {
						Błąd(dokument).DodajBłąd("Podejrzanie wysoka cena pozycji "+poz+" "+poz.Cena);
						break;
					}
					else if (d.Value>poz.Cena.Value*Parametry.ProporcjaCeny) {
						Błąd(dokument).DodajBłąd("Podejrzanie niska cena pozycji "+poz+" "+poz.Cena);
						break;
					}
				}
			}
		}
	}
}

void sprawdźTowary(DokumentHandlowy dokument) {
	Set tows = new Set();
	foreach (PozycjaDokHandlowego poz in dokument.Pozycje)
		if (tows.Contains(poz.Towar))
			Błąd(dokument).DodajBłąd("Powtarzający się towar "+poz.Towar+" w pozycjach dokumentu");
		else
			tows += poz.Towar;
}

void sprawdźPuste(DokumentHandlowy dokument) {
	foreach (PozycjaDokHandlowego poz in dokument.Pozycje)
		return;
	Błąd(dokument).DodajBłąd("Pusty dokument, bez pozycji.");
}

class KasaVerifier : Soneta.Kasa.ZobowiazaniaVerifier {
	public KasaVerifier(DokumentHandlowy dokument) : base(dokument) {}
	
	public bool Poprawny() {
		return IsValid();
	}
}

void dc_ContextLoad(Object sender, EventArgs args) {

	Hashtable dup = new Hashtable();

	int licznik = 0;
	foreach (DokumentHandlowy dokument in (Row[])dc[typeof(Row[])]) {
		if (++licznik % 100 == 0)
			System.Diagnostics.Trace.Write("Analizuje dokumenty: "+licznik, "Progress");
			
		//////////////////////////////////////////////////////////////
		/// Sprawdzenie duplikatów
		///
		if (Parametry.DuplikatyDokumentów 
			&& dokument.Kontrahent!=null && !dokument.Kontrahent.JestIncydentalny
			&& dokument.Definicja!=dokument.Module.DefDokHandlowych.KorektaPZWZ) {
			string n = klucz(dokument);
			ArrayList dupt = (ArrayList)dup[n];
			if (dupt==null) {
				dupt = new ArrayList();
				dup[n] = dupt;
			}
			dupt.Add(dokument);
		}
		
		//////////////////////////////////////////////////////////////
		/// Sprawdzenie dokumentów w buforze
		///
		if (Parametry.DokumentyWBuforze && dokument.Stan==StanDokumentuHandlowego.Bufor)
			Błąd(dokument).DodajBłąd("Dokument pozostaje w buforze");

		//////////////////////////////////////////////////////////////
		/// Sprawdzenie czy jest dokument zależny
		///
		if (Parametry.RelacjePodrzędne)
			sprawdźRelacje(dokument);

		//////////////////////////////////////////////////////////////
		/// Sprawdzenie poprawności sumy płatności
		///
		if (Parametry.PoprawnośćPłatności && dokument.Definicja.KierunekPlatnosci!=KierunekPlatnosci.Brak)
			if (!new KasaVerifier(dokument).Poprawny())
				Błąd(dokument).DodajBłąd("Niezgodność płatności z wartością dokumentu");

		//////////////////////////////////////////////////////////////
		/// Sprawdzenie cen pozycji dokumentów
		///
		if (Parametry.PodejrzaneCeny)
			sprawdźCeny(dokument);

		//////////////////////////////////////////////////////////////
		/// Sprawdzenie powtarzających się towarów
		///
		if (Parametry.DuplikatyPozycji)
			sprawdźTowary(dokument);

		//////////////////////////////////////////////////////////////
		/// Sprawdzenie pustych dokumentów
		///
		if (Parametry.BezPozycji)
			sprawdźPuste(dokument);
	}
	
	foreach (ArrayList dupt in dup.Values) {
		if (dupt.Count>1) {
			foreach (DokumentHandlowy dok in dupt) {
				string s = "Powtórzenie dokumentów: ";
				foreach (DokumentHandlowy dok2 in dupt)
					if (dok!=dok2)
						s += dok2+", ";
				Błąd(dok).DodajBłąd(s.Substring(0, s.Length-2));
			}
		}
	}

    ArrayList arr = new ArrayList();
    foreach(BłędnyDokument bdok in ht.Values) {
        foreach(string błąd in bdok.Błędy) {
            BłędnyDokument arrbdok = new BłędnyDokument(bdok.Dokument);
            arrbdok.DodajBłąd(błąd);
            arr.Add(arrbdok);
        }
    }
    
	arr.Sort();
	Grid.DataSource = arr;
}


		</script>
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" title="Podejrzane dokumenty</strong>|Raport zawiera dokumenty, których edycji/przetwarzania nie zakończono oraz takie, w których występują nieoczekiwane dane."
				runat="server"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="18" Align="Left" DataMember="Dokument.Numer" Caption="Numer" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Center" DataMember="Dokument.Data" Caption="Data" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="17" DataMember="Dokument.Kontrahent.Kod" Caption="Kod kontrahenta" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" DataMember="Dokument.Suma.Netto" Caption="Netto" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" DataMember="Dokument.Suma.Brutto" Caption="Brutto" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn DataMember="Błędy" Caption="Opis problemu" EncodeHTML="True" runat="server"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</HTML>

